#ifndef __CANOPEN_MASTER_ERROR_H
#define __CANOPEN_MASTER_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// CANopen Master
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_CANOPEN_MASTER_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_CANOPEN_MASTER_COMMAND_INVALID ((TLR_RESULT)0xC0420001L)

//
// MessageId: TLR_E_CANOPEN_MASTER_PACKET_LENGTH
//
// MessageText:
//
//  Invalid length in packet.
//
#define TLR_E_CANOPEN_MASTER_PACKET_LENGTH ((TLR_RESULT)0xC0420002L)

//
// MessageId: TLR_E_CANOPEN_MASTER_DATA_COUNT
//
// MessageText:
//
//  Invalid data count.
//
#define TLR_E_CANOPEN_MASTER_DATA_COUNT  ((TLR_RESULT)0xC0420003L)

//
// MessageId: TLR_E_CANOPEN_MASTER_DATA_OFFSET
//
// MessageText:
//
//  Invalid data offset.
//
#define TLR_E_CANOPEN_MASTER_DATA_OFFSET ((TLR_RESULT)0xC0420004L)

//
// MessageId: TLR_E_CANOPEN_MASTER_DATA_COUNT_WITH_OFFSET
//
// MessageText:
//
//  Invalid data count in combination with offset.
//
#define TLR_E_CANOPEN_MASTER_DATA_COUNT_WITH_OFFSET ((TLR_RESULT)0xC0420005L)

//
// MessageId: TLR_E_CANOPEN_MASTER_MODE
//
// MessageText:
//
//  Invalid mode in command.
//
#define TLR_E_CANOPEN_MASTER_MODE        ((TLR_RESULT)0xC0420006L)

//
// MessageId: TLR_E_CANOPEN_MASTER_STATE
//
// MessageText:
//
//  Command is not allowed in current state.
//
#define TLR_E_CANOPEN_MASTER_STATE       ((TLR_RESULT)0xC0420007L)

//
// MessageId: TLR_E_CANOPEN_MASTER_NO_VALID_BUS_PARAM
//
// MessageText:
//
//  No valid bus configuration parameterized.
//
#define TLR_E_CANOPEN_MASTER_NO_VALID_BUS_PARAM ((TLR_RESULT)0xC0420008L)

//
// MessageId: TLR_E_CANOPEN_MASTER_REQUEST_RUNNING
//
// MessageText:
//
//  A request is already running.
//
#define TLR_E_CANOPEN_MASTER_REQUEST_RUNNING ((TLR_RESULT)0xC0420009L)

//
// MessageId: TLR_E_CANOPEN_MASTER_BUS_RUNNING
//
// MessageText:
//
//  Command is not allowed because CANopen is running.
//
#define TLR_E_CANOPEN_MASTER_BUS_RUNNING ((TLR_RESULT)0xC042000AL)

//
// MessageId: TLR_E_CANOPEN_MASTER_BUS_PARAM_ALREADY_SET
//
// MessageText:
//
//  Bus parameters are already configured.
//
#define TLR_E_CANOPEN_MASTER_BUS_PARAM_ALREADY_SET ((TLR_RESULT)0xC042000BL)

//
// MessageId: TLR_E_CANOPEN_MASTER_LOCAL_NODE_ID
//
// MessageText:
//
//  Invalid Node ID for CANopen Master.
//
#define TLR_E_CANOPEN_MASTER_LOCAL_NODE_ID ((TLR_RESULT)0xC042000CL)

//
// MessageId: TLR_E_CANOPEN_MASTER_BAUDRATE
//
// MessageText:
//
//  Invalid Baudrate.
//
#define TLR_E_CANOPEN_MASTER_BAUDRATE    ((TLR_RESULT)0xC042000DL)

//
// MessageId: TLR_E_CANOPEN_MASTER_29BIT_SELECTOR
//
// MessageText:
//
//  Invaiid parameter for 29 bit selector.
//
#define TLR_E_CANOPEN_MASTER_29BIT_SELECTOR ((TLR_RESULT)0xC042000EL)

//
// MessageId: TLR_E_CANOPEN_MASTER_SYNC_TIMER_VALUE
//
// MessageText:
//
//  Invaiid parameter for SYNC timer.
//
#define TLR_E_CANOPEN_MASTER_SYNC_TIMER_VALUE ((TLR_RESULT)0xC042000FL)

//
// MessageId: TLR_E_CANOPEN_MASTER_COB_ID_SYNC
//
// MessageText:
//
//  Invaiid parameter for COB-ID SYNC.
//
#define TLR_E_CANOPEN_MASTER_COB_ID_SYNC ((TLR_RESULT)0xC0420010L)

//
// MessageId: TLR_E_CANOPEN_MASTER_PROD_HEARTBEAT_TIME
//
// MessageText:
//
//  Invaiid parameter for Producer Heartbeat time.
//
#define TLR_E_CANOPEN_MASTER_PROD_HEARTBEAT_TIME ((TLR_RESULT)0xC0420011L)

//
// MessageId: TLR_E_CANOPEN_MASTER_PACKET_SEQUENCE
//
// MessageText:
//
//  Invalid packet sequence detected.
//
#define TLR_E_CANOPEN_MASTER_PACKET_SEQUENCE ((TLR_RESULT)0xC0420012L)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_PARAM_SET_SIZE
//
// MessageText:
//
//  Invalid size of Node parameter set.
//
#define TLR_E_CANOPEN_MASTER_NODE_PARAM_SET_SIZE ((TLR_RESULT)0xC0420013L)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_PARAM_HEADER_SIZE
//
// MessageText:
//
//  Invalid size of Node parameter header.
//
#define TLR_E_CANOPEN_MASTER_NODE_PARAM_HEADER_SIZE ((TLR_RESULT)0xC0420014L)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_ALREADY_CONFIGURED
//
// MessageText:
//
//  Node is already configured.
//
#define TLR_E_CANOPEN_MASTER_NODE_ALREADY_CONFIGURED ((TLR_RESULT)0xC0420015L)

//
// MessageId: TLR_E_CANOPEN_MASTER_SLAVE_NODE_ID
//
// MessageText:
//
//  Invalid Node ID for Slave.
//
#define TLR_E_CANOPEN_MASTER_SLAVE_NODE_ID ((TLR_RESULT)0xC0420016L)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_ID_EQUAL
//
// MessageText:
//
//  Node ID of Slave is equal to Master Node ID.
//
#define TLR_E_CANOPEN_MASTER_NODE_ID_EQUAL ((TLR_RESULT)0xC0420017L)

//
// MessageId: TLR_E_CANOPEN_MASTER_PARAMETER_SET_LENGTH
//
// MessageText:
//
//  Length of parameter set is different from length in parameter header.
//
#define TLR_E_CANOPEN_MASTER_PARAMETER_SET_LENGTH ((TLR_RESULT)0xC0420018L)

//
// MessageId: TLR_E_CANOPEN_MASTER_SDO_PARAMETER_SET_LENGTH
//
// MessageText:
//
//  Invalid size of SDO parameter set.
//
#define TLR_E_CANOPEN_MASTER_SDO_PARAMETER_SET_LENGTH ((TLR_RESULT)0xC0420019L)

//
// MessageId: TLR_E_CANOPEN_MASTER_PDO_PARAMETER_SET_LENGTH
//
// MessageText:
//
//  Invalid size of PDO parameter set.
//
#define TLR_E_CANOPEN_MASTER_PDO_PARAMETER_SET_LENGTH ((TLR_RESULT)0xC042001AL)

//
// MessageId: TLR_E_CANOPEN_MASTER_ADDR_TABLE_SET_LENGTH
//
// MessageText:
//
//  Invalid size of address table.
//
#define TLR_E_CANOPEN_MASTER_ADDR_TABLE_SET_LENGTH ((TLR_RESULT)0xC042001BL)

//
// MessageId: TLR_E_CANOPEN_MASTER_ADDR_TABLE_LENGTH_INCONSISTENT
//
// MessageText:
//
//  Address table size is inconsistent.
//
#define TLR_E_CANOPEN_MASTER_ADDR_TABLE_LENGTH_INCONSISTENT ((TLR_RESULT)0xC042001CL)

//
// MessageId: TLR_E_CANOPEN_MASTER_TPDO_CNT
//
// MessageText:
//
//  Invalid number of transmitt PDOs.
//
#define TLR_E_CANOPEN_MASTER_TPDO_CNT    ((TLR_RESULT)0xC042001EL)

//
// MessageId: TLR_E_CANOPEN_MASTER_RPDO_CNT
//
// MessageText:
//
//  Invalid number of receive PDOs.
//
#define TLR_E_CANOPEN_MASTER_RPDO_CNT    ((TLR_RESULT)0xC042001FL)

//
// MessageId: TLR_E_CANOPEN_MASTER_COB_ID_EMCY
//
// MessageText:
//
//  Invalid value for COB-ID Emergency.
//
#define TLR_E_CANOPEN_MASTER_COB_ID_EMCY ((TLR_RESULT)0xC0420020L)

//
// MessageId: TLR_E_CANOPEN_MASTER_COB_ID_GUARD
//
// MessageText:
//
//  Invalid value for COB-ID Guard.
//
#define TLR_E_CANOPEN_MASTER_COB_ID_GUARD ((TLR_RESULT)0xC0420021L)

//
// MessageId: TLR_E_CANOPEN_MEMORY_ALLOCATION
//
// MessageText:
//
//  No memory for parameter set.
//
#define TLR_E_CANOPEN_MEMORY_ALLOCATION  ((TLR_RESULT)0xC0420022L)

//
// MessageId: TLR_E_CANOPEN_SDO_DATA_CNT
//
// MessageText:
//
//  Invalid value for SDO data count.
//
#define TLR_E_CANOPEN_SDO_DATA_CNT       ((TLR_RESULT)0xC0420023L)

//
// MessageId: TLR_E_CANOPEN_PDO_DATA_CNT
//
// MessageText:
//
//  Invalid value for PDO data count.
//
#define TLR_E_CANOPEN_PDO_DATA_CNT       ((TLR_RESULT)0xC0420024L)

//
// MessageId: TLR_E_CANOPEN_ADDR_TAB_DATA_CNT
//
// MessageText:
//
//  Invalid value for address table data count.
//
#define TLR_E_CANOPEN_ADDR_TAB_DATA_CNT  ((TLR_RESULT)0xC0420025L)

//
// MessageId: TLR_E_CANOPEN_ADDR_TAB_PDO_CNT
//
// MessageText:
//
//  Invalid value for address table PDO count.
//
#define TLR_E_CANOPEN_ADDR_TAB_PDO_CNT   ((TLR_RESULT)0xC0420026L)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_SDO_TIMEOUT
//
// MessageText:
//
//  Timeout during SDO transfer.
//
#define TLR_E_CANOPEN_MASTER_NODE_SDO_TIMEOUT ((TLR_RESULT)0xC0420027L)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_SDO_ERROR
//
// MessageText:
//
//  Error during SDO transfer.
//
#define TLR_E_CANOPEN_MASTER_NODE_SDO_ERROR ((TLR_RESULT)0xC0420028L)

//
// MessageId: TLR_E_CANOPEN_MASTER_NO_PDO_AVAILABLE
//
// MessageText:
//
//  No further PDO available.
//
#define TLR_E_CANOPEN_MASTER_NO_PDO_AVAILABLE ((TLR_RESULT)0xC0420029L)

//
// MessageId: TLR_E_CANOPEN_MASTER_AUTO_CLEAR_ACTIVE
//
// MessageText:
//
//  Master is in auto clear state.
//
#define TLR_E_CANOPEN_MASTER_AUTO_CLEAR_ACTIVE ((TLR_RESULT)0xC042002AL)

//
// MessageId: TLR_E_CANOPEN_MASTER_WATCHDOG_FAIL
//
// MessageText:
//
//  Watchdog failure detected.
//
#define TLR_E_CANOPEN_MASTER_WATCHDOG_FAIL ((TLR_RESULT)0xC042002BL)

//
// MessageId: TLR_E_CANOPEN_MASTER_INVALID_INDEX
//
// MessageText:
//
//  Invalid index for request.
//
#define TLR_E_CANOPEN_MASTER_INVALID_INDEX ((TLR_RESULT)0xC042002CL)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_STATE
//
// MessageText:
//
//  Request not possible in current Node state.
//
#define TLR_E_CANOPEN_MASTER_NODE_STATE  ((TLR_RESULT)0xC042002DL)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_NOT_CONFIGURED
//
// MessageText:
//
//  Node is not configuerd.
//
#define TLR_E_CANOPEN_MASTER_NODE_NOT_CONFIGURED ((TLR_RESULT)0xC042002EL)

//
// MessageId: TLR_E_CANOPEN_MASTER_SDO_REQUEST_FAILED
//
// MessageText:
//
//  SDO request failed.
//
#define TLR_E_CANOPEN_MASTER_SDO_REQUEST_FAILED ((TLR_RESULT)0xC042002FL)

//
// MessageId: TLR_I_CANOPEN_MASTER_ALREADY_IN_STATE
//
// MessageText:
//
//  Master is already in requested state.
//
#define TLR_I_CANOPEN_MASTER_ALREADY_IN_STATE ((TLR_RESULT)0x40420030L)

//
// MessageId: TLR_E_CANOPEN_MASTER_COB_ID_PDO
//
// MessageText:
//
//  Invalid value for PDO COB-ID.
//
#define TLR_E_CANOPEN_MASTER_COB_ID_PDO  ((TLR_RESULT)0xC0420031L)

//
// MessageId: TLR_E_CANOPEN_MASTER_SEND_EMCY
//
// MessageText:
//
//  Send emergency-telegram failed.
//
#define TLR_E_CANOPEN_MASTER_SEND_EMCY   ((TLR_RESULT)0xC0420032L)

//
// MessageId: TLR_E_CANOPEN_MASTER_INIT_SDO_REQUEST
//
// MessageText:
//
//  Failed to initialize SDO request.
//
#define TLR_E_CANOPEN_MASTER_INIT_SDO_REQUEST ((TLR_RESULT)0xC0420033L)

//
// MessageId: TLR_E_CANOPEN_MASTER_SET_NMT_STATE
//
// MessageText:
//
//  Set NMT state failed.
//
#define TLR_E_CANOPEN_MASTER_SET_NMT_STATE ((TLR_RESULT)0xC0420034L)

//
// MessageId: TLR_E_CANOPEN_MASTER_ERROR_PASSIVE
//
// MessageText:
//
//  CANopen is in error-passive state.
//
#define TLR_E_CANOPEN_MASTER_ERROR_PASSIVE ((TLR_RESULT)0xC0420035L)

//
// MessageId: TLR_E_CANOPEN_MASTER_BUS_OFF
//
// MessageText:
//
//  CANopen is in bus-off state.
//
#define TLR_E_CANOPEN_MASTER_BUS_OFF     ((TLR_RESULT)0xC0420036L)

//
// MessageId: TLR_I_CANOPEN_MASTER_NODE_DEACTIVATED
//
// MessageText:
//
//  Node is deactivated in configuration.
//
#define TLR_I_CANOPEN_MASTER_NODE_DEACTIVATED ((TLR_RESULT)0x40420037L)

//
// MessageId: TLR_E_CANOPEN_MASTER_DL_REQ_FAILED
//
// MessageText:
//
//  CAN-DL request failed.
//
#define TLR_E_CANOPEN_MASTER_DL_REQ_FAILED ((TLR_RESULT)0xC0420038L)

//
// MessageId: TLR_E_CANOPEN_MASTER_PUT_OBJECT_DATA
//
// MessageText:
//
//  Failed to write object data.
//
#define TLR_E_CANOPEN_MASTER_PUT_OBJECT_DATA ((TLR_RESULT)0xC0420039L)

//
// MessageId: TLR_E_CANOPEN_MASTER_SET_OBJECT_DATA_VALID
//
// MessageText:
//
//  Failed to set object data valid.
//
#define TLR_E_CANOPEN_MASTER_SET_OBJECT_DATA_VALID ((TLR_RESULT)0xC042003AL)

//
// MessageId: TLR_E_CANOPEN_MASTER_INIT_LIB
//
// MessageText:
//
//  Failed to initialite CANopen library.
//
#define TLR_E_CANOPEN_MASTER_INIT_LIB    ((TLR_RESULT)0xC042003BL)

//
// MessageId: TLR_E_CANOPEN_MASTER_SET_COB_ID_FAILED
//
// MessageText:
//
//  COB-ID could not be set.
//
#define TLR_E_CANOPEN_MASTER_SET_COB_ID_FAILED ((TLR_RESULT)0xC042003CL)

//
// MessageId: TLR_E_CANOPEN_MASTER_ADD_REMOTE_NODE_REQUEST
//
// MessageText:
//
//  Failed to add remote Node.
//
#define TLR_E_CANOPEN_MASTER_ADD_REMOTE_NODE_REQUEST ((TLR_RESULT)0xC042003DL)

//
// MessageId: TLR_E_CANOPEN_MASTER_SET_HEARTBEAT_TIME
//
// MessageText:
//
//  Heartbeat time could not be set.
//
#define TLR_E_CANOPEN_MASTER_SET_HEARTBEAT_TIME ((TLR_RESULT)0xC042003EL)

//
// MessageId: TLR_E_CANOPEN_MASTER_ADD_GUARDING_SLAVE
//
// MessageText:
//
//  Node could not be added to Node guarding list.
//
#define TLR_E_CANOPEN_MASTER_ADD_GUARDING_SLAVE ((TLR_RESULT)0xC042003FL)

//
// MessageId: TLR_E_CANOPEN_MASTER_SET_GUARDING_TIME
//
// MessageText:
//
//  Node guard time could not be set.
//
#define TLR_E_CANOPEN_MASTER_SET_GUARDING_TIME ((TLR_RESULT)0xC0420040L)

//
// MessageId: TLR_E_CANOPEN_MASTER_START_NODE_GUARD
//
// MessageText:
//
//  Node guarding could not be started.
//
#define TLR_E_CANOPEN_MASTER_START_NODE_GUARD ((TLR_RESULT)0xC0420041L)

//
// MessageId: TLR_E_CANOPEN_MASTER_RESET_NODE
//
// MessageText:
//
//  Reset Node failed.
//
#define TLR_E_CANOPEN_MASTER_RESET_NODE  ((TLR_RESULT)0xC0420042L)

//
// MessageId: TLR_E_CANOPEN_MASTER_RESET_COMMUNICATION
//
// MessageText:
//
//  Failed to reset communication of Node.
//
#define TLR_E_CANOPEN_MASTER_RESET_COMMUNICATION ((TLR_RESULT)0xC0420043L)

//
// MessageId: TLR_E_CANOPEN_MASTER_SET_NODE_PREOPERATIONAL
//
// MessageText:
//
//  Failed to set Node to preoperational state.
//
#define TLR_E_CANOPEN_MASTER_SET_NODE_PREOPERATIONAL ((TLR_RESULT)0xC0420044L)

//
// MessageId: TLR_E_CANOPEN_MASTER_STOP_NODE
//
// MessageText:
//
//  Failed to set Node to stop state.
//
#define TLR_E_CANOPEN_MASTER_STOP_NODE   ((TLR_RESULT)0xC0420045L)

//
// MessageId: TLR_E_CANOPEN_MASTER_START_NODE
//
// MessageText:
//
//  Failed to set Node to operational state.
//
#define TLR_E_CANOPEN_MASTER_START_NODE  ((TLR_RESULT)0xC0420046L)

//
// MessageId: TLR_E_CANOPEN_MASTER_SET_EMCY_COB_ID
//
// MessageText:
//
//  Failed to set Emergency COB-ID.
//
#define TLR_E_CANOPEN_MASTER_SET_EMCY_COB_ID ((TLR_RESULT)0xC0420047L)

//
// MessageId: TLR_E_CANOPEN_MASTER_START_SYNC
//
// MessageText:
//
//  Failed to start SYNC-telegram.
//
#define TLR_E_CANOPEN_MASTER_START_SYNC  ((TLR_RESULT)0xC0420048L)

//
// MessageId: TLR_E_CANOPEN_MASTER_STOP_SYNC
//
// MessageText:
//
//  Failed to stop SYNC-telegram.
//
#define TLR_E_CANOPEN_MASTER_STOP_SYNC   ((TLR_RESULT)0xC0420049L)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_UNEXPECTED_STATE
//
// MessageText:
//
//  Node is not in expected state.
//
#define TLR_E_CANOPEN_MASTER_NODE_UNEXPECTED_STATE ((TLR_RESULT)0xC042004AL)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_LOST_CONNECTION
//
// MessageText:
//
//  Connection to Node lost.
//
#define TLR_E_CANOPEN_MASTER_NODE_LOST_CONNECTION ((TLR_RESULT)0xC042004BL)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_GUARDING_ERROR
//
// MessageText:
//
//  Node guarding error.
//
#define TLR_E_CANOPEN_MASTER_NODE_GUARDING_ERROR ((TLR_RESULT)0xC042004CL)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_HEARTBEAT_ERROR
//
// MessageText:
//
//  Heartbeat error.
//
#define TLR_E_CANOPEN_MASTER_NODE_HEARTBEAT_ERROR ((TLR_RESULT)0xC042004DL)

//
// MessageId: TLR_I_CANOPEN_MASTER_NODE_HEARTBEAT_STARTED
//
// MessageText:
//
//  Heartbeat supervision of Node started.
//
#define TLR_I_CANOPEN_MASTER_NODE_HEARTBEAT_STARTED ((TLR_RESULT)0x4042004EL)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_UNEXPECTED_BOOTUP
//
// MessageText:
//
//  Unexpected Bootup message from Node received.
//
#define TLR_E_CANOPEN_MASTER_NODE_UNEXPECTED_BOOTUP ((TLR_RESULT)0xC042004FL)

//
// MessageId: TLR_E_CANOPEN_MASTER_WRITE_PDO_REQ
//
// MessageText:
//
//  Failed to transmit PDO.
//
#define TLR_E_CANOPEN_MASTER_WRITE_PDO_REQ ((TLR_RESULT)0xC0420050L)

//
// MessageId: TLR_E_CANOPEN_MASTER_READ_PDO_REQ
//
// MessageText:
//
//  Failed to request PDO.
//
#define TLR_E_CANOPEN_MASTER_READ_PDO_REQ ((TLR_RESULT)0xC0420051L)

//
// MessageId: TLR_E_CANOPEN_MASTER_INIT_BUFFER
//
// MessageText:
//
//  Initialization of buffer failed.
//
#define TLR_E_CANOPEN_MASTER_INIT_BUFFER ((TLR_RESULT)0xC0420052L)

//
// MessageId: TLR_I_CANOPEN_MASTER_NODE_STATE_NOT_HANDLED
//
// MessageText:
//
//  State of Node not handled.
//
#define TLR_I_CANOPEN_MASTER_NODE_STATE_NOT_HANDLED ((TLR_RESULT)0x40420053L)

//
// MessageId: TLR_E_CANOPEN_MASTER_NODE_DEVICE_TYPE
//
// MessageText:
//
//  Node Device Type unequal to configured Device Type.
//
#define TLR_E_CANOPEN_MASTER_NODE_DEVICE_TYPE ((TLR_RESULT)0xC0420054L)

//
// MessageId: TLR_I_CANOPEN_MASTER_NODE_EMERGENCY_RECEIVED
//
// MessageText:
//
//  Emergency message received from Node.
//
#define TLR_I_CANOPEN_MASTER_NODE_EMERGENCY_RECEIVED ((TLR_RESULT)0x40420055L)

//
// MessageId: TLR_I_CANOPEN_MASTER_INITIALIZE
//
// MessageText:
//
//  Master is initializing.
//
#define TLR_I_CANOPEN_MASTER_INITIALIZE  ((TLR_RESULT)0x40420056L)

//
// MessageId: TLR_I_CANOPEN_MASTER_NODE_BOOTUP
//
// MessageText:
//
//  Bootup message from Node received.
//
#define TLR_I_CANOPEN_MASTER_NODE_BOOTUP ((TLR_RESULT)0x40420057L)

//
// MessageId: TLR_E_CANOPEN_MASTER_RESERVED_1
//
// MessageText:
//
//  Reserved.
//
#define TLR_E_CANOPEN_MASTER_RESERVED_1  ((TLR_RESULT)0xC0420058L)

//
// MessageId: TLR_E_CANOPEN_MASTER_RESERVED_2
//
// MessageText:
//
//  Reserved.
//
#define TLR_E_CANOPEN_MASTER_RESERVED_2  ((TLR_RESULT)0xC0420059L)

//
// MessageId: TLR_E_CANOPEN_MASTER_RESERVED_3
//
// MessageText:
//
//  Reserved.
//
#define TLR_E_CANOPEN_MASTER_RESERVED_3  ((TLR_RESULT)0xC042005AL)

//
// MessageId: TLR_E_CANOPEN_MASTER_RESERVED_4
//
// MessageText:
//
//  Reserved.
//
#define TLR_E_CANOPEN_MASTER_RESERVED_4  ((TLR_RESULT)0xC042005BL)

//
// MessageId: TLR_E_CANOPEN_MASTER_RESERVED_5
//
// MessageText:
//
//  Reserved.
//
#define TLR_E_CANOPEN_MASTER_RESERVED_5  ((TLR_RESULT)0xC042005CL)




#endif  //__CANOPEN_MASTER_ERROR_H

